/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.jetifier.standalone;

import com.android.tools.build.jetifier.core.pom.PomDependency;
import com.android.tools.build.jetifier.processor.archive.Archive;
import com.android.tools.build.jetifier.processor.archive.ArchiveFile;
import com.android.tools.build.jetifier.processor.archive.ArchiveItem;
import com.android.tools.build.jetifier.processor.archive.ArchiveItemVisitor;
import com.android.tools.build.jetifier.processor.transform.pom.PomDocument;
import com.android.tools.build.jetifier.standalone.TopOfTreeBuilder;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J.\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0002J\u0016\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/build/jetifier/standalone/TopOfTreeBuilder;", "", "()V", "getHashFileOf", "Lcom/android/tools/build/jetifier/processor/archive/ArchiveFile;", "file", "hashType", "", "process", "", "pomFile", "artifactFile", "sourcesFile", "resultSet", "", "rebuildFrom", "inputZip", "Ljava/io/File;", "outputZip", "Companion", "FileFilter", "jetifier-standalone"})
public final class TopOfTreeBuilder {
    @NotNull
    public static final String DIR_PREFIX = "m2repository";
    public static final Companion Companion = new Companion(null);

    public final void rebuildFrom(@NotNull File inputZip, @NotNull File outputZip) {
        Intrinsics.checkParameterIsNotNull((Object)inputZip, (String)"inputZip");
        Intrinsics.checkParameterIsNotNull((Object)outputZip, (String)"outputZip");
        Archive archive = Archive.Builder.INSTANCE.extract(inputZip, false);
        FileFilter pomFilter2 = new FileFilter((Function1<? super ArchiveFile, Boolean>)((Function1)rebuildFrom.pomFilter.1.INSTANCE));
        archive.accept((ArchiveItemVisitor)pomFilter2);
        Set<ArchiveFile> pomFiles = pomFilter2.getFiles();
        FileFilter archivesFilter2 = new FileFilter((Function1<? super ArchiveFile, Boolean>)((Function1)rebuildFrom.archivesFilter.1.INSTANCE));
        archive.accept((ArchiveItemVisitor)archivesFilter2);
        Set<ArchiveFile> libFiles = archivesFilter2.getFiles();
        boolean bl = false;
        Set newFiles = new LinkedHashSet();
        Iterable $this$forEach$iv = pomFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object element$iv22;
            ArchiveFile artifactFile;
            TopOfTreeBuilder $this$run;
            ArchiveFile pomFile;
            block4: {
                Object element$iv32;
                String name;
                block3: {
                    pomFile = (ArchiveFile)element$iv;
                    boolean bl2 = false;
                    TopOfTreeBuilder topOfTreeBuilder = this;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    $this$run = topOfTreeBuilder;
                    boolean bl5 = false;
                    File file = pomFile.getRelativePath().toFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"pomFile.relativePath.toFile()");
                    name = FilesKt.getNameWithoutExtension((File)file);
                    String nameAar = name + ".aar";
                    String nameJar = name + ".jar";
                    Iterable $this$first$iv = libFiles;
                    boolean $i$f$first = false;
                    for (Object element$iv32 : $this$first$iv) {
                        ArchiveFile it = (ArchiveFile)element$iv32;
                        boolean bl6 = false;
                        if (!(Intrinsics.areEqual((Object)it.getFileName(), (Object)nameAar) || Intrinsics.areEqual((Object)it.getFileName(), (Object)nameJar))) continue;
                        break block3;
                    }
                    throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                artifactFile = (ArchiveFile)element$iv32;
                String nameSources = name + "-sources.jar";
                Iterable $this$first$iv = libFiles;
                boolean $i$f$first = false;
                for (Object element$iv22 : $this$first$iv) {
                    ArchiveFile it = (ArchiveFile)element$iv22;
                    boolean bl7 = false;
                    if (!Intrinsics.areEqual((Object)it.getFileName(), (Object)nameSources)) continue;
                    break block4;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            ArchiveFile sourcesFile = (ArchiveFile)element$iv22;
            $this$run.process(pomFile, artifactFile, sourcesFile, newFiles);
        }
        Path path = outputZip.toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"outputZip.toPath()");
        Archive finalArchive = new Archive(path, CollectionsKt.toList((Iterable)newFiles));
        finalArchive.writeSelf();
    }

    private final void process(ArchiveFile pomFile, ArchiveFile artifactFile, ArchiveFile sourcesFile, Set<ArchiveFile> resultSet) {
        PomDependency pomDep = PomDocument.Companion.loadFrom(pomFile).getAsPomDependency();
        String string = pomDep.getGroupId();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String groupAsPath = StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null);
        File file = artifactFile.getRelativePath().toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"artifactFile.relativePath.toFile()");
        String packaging = FilesKt.getExtension((File)file);
        String baseFileName = pomDep.getArtifactId() + '-' + pomDep.getVersion();
        String[] stringArray = new String[3];
        stringArray[0] = groupAsPath;
        stringArray[1] = pomDep.getArtifactId();
        String string2 = pomDep.getVersion();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        stringArray[2] = string2;
        Path artifactDir = Paths.get(DIR_PREFIX, stringArray);
        Path newLibFilePath = Paths.get(((Object)artifactDir).toString(), baseFileName + '.' + packaging);
        Path newPomFilePath = Paths.get(((Object)artifactDir).toString(), baseFileName + ".pom");
        Path newSourcesFilePath = Paths.get(((Object)artifactDir).toString(), baseFileName + "-sources.jar");
        Path path = newLibFilePath;
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"newLibFilePath");
        ArchiveFile newArtifactFile = new ArchiveFile(path, artifactFile.getData());
        Path path2 = newPomFilePath;
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"newPomFilePath");
        ArchiveFile newPomFile = new ArchiveFile(path2, pomFile.getData());
        Path path3 = newSourcesFilePath;
        Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"newSourcesFilePath");
        ArchiveFile newSourcesFile = new ArchiveFile(path3, sourcesFile.getData());
        resultSet.add(newArtifactFile);
        resultSet.add(this.getHashFileOf(newArtifactFile, "MD5"));
        resultSet.add(this.getHashFileOf(newArtifactFile, "SHA1"));
        resultSet.add(newPomFile);
        resultSet.add(this.getHashFileOf(newPomFile, "MD5"));
        resultSet.add(this.getHashFileOf(newPomFile, "SHA1"));
        resultSet.add(newSourcesFile);
        resultSet.add(this.getHashFileOf(newSourcesFile, "MD5"));
        resultSet.add(this.getHashFileOf(newSourcesFile, "SHA1"));
    }

    private final ArchiveFile getHashFileOf(ArchiveFile file, String hashType) {
        MessageDigest md = MessageDigest.getInstance(hashType);
        byte[] result = md.digest(file.getData());
        String string = hashType;
        StringBuilder stringBuilder = new StringBuilder().append(((Object)file.getRelativePath()).toString()).append(".");
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String string4 = string3;
        Path path = Paths.get(stringBuilder.append(string4).toString(), new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(\n            f\u2026+ hashType.toLowerCase())");
        Intrinsics.checkExpressionValueIsNotNull((Object)result, (String)"result");
        byte[] byArray = result;
        Path path2 = path;
        return new ArchiveFile(path2, byArray);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0004H\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/build/jetifier/standalone/TopOfTreeBuilder$FileFilter;", "Lcom/android/tools/build/jetifier/processor/archive/ArchiveItemVisitor;", "filter", "Lkotlin/Function1;", "Lcom/android/tools/build/jetifier/processor/archive/ArchiveFile;", "", "(Lkotlin/jvm/functions/Function1;)V", "files", "", "getFiles", "()Ljava/util/Set;", "visit", "", "archive", "Lcom/android/tools/build/jetifier/processor/archive/Archive;", "archiveFile", "jetifier-standalone"})
    private static final class FileFilter
    implements ArchiveItemVisitor {
        @NotNull
        private final Set<ArchiveFile> files;
        private final Function1<ArchiveFile, Boolean> filter;

        @NotNull
        public final Set<ArchiveFile> getFiles() {
            return this.files;
        }

        public void visit(@NotNull ArchiveFile archiveFile) {
            Intrinsics.checkParameterIsNotNull((Object)archiveFile, (String)"archiveFile");
            if (((Boolean)this.filter.invoke((Object)archiveFile)).booleanValue()) {
                this.files.add(archiveFile);
            }
        }

        public void visit(@NotNull Archive archive) {
            Intrinsics.checkParameterIsNotNull((Object)archive, (String)"archive");
            Iterable $this$forEach$iv = archive.getFiles();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ArchiveItem it = (ArchiveItem)element$iv;
                boolean bl = false;
                it.accept((ArchiveItemVisitor)this);
            }
        }

        public FileFilter(@NotNull Function1<? super ArchiveFile, Boolean> filter) {
            Set set;
            Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
            this.filter = filter;
            FileFilter fileFilter = this;
            boolean bl = false;
            fileFilter.files = set = (Set)new LinkedHashSet();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/build/jetifier/standalone/TopOfTreeBuilder$Companion;", "", "()V", "DIR_PREFIX", "", "jetifier-standalone"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

